#include <thread>
#include <stdio.h>
#include <iostream>
#include <string>
#include <cstdlib>
#include <vector>
using namespace std;

void run(string exp_name, string checkpoint, int key_offset, int thread_order) {
    char exename[100];
    sprintf(exename, "./ppo_point_val_pof.out %s %s %d %d", exp_name.c_str(), checkpoint.c_str(), key_offset, thread_order);
    system(exename);
}

thread threads[20];
vector<pair<string, int>> val_exp_set = {
    {"pofval_poftraining_ppo_point_nolag", 456789},
    {"pofval_poftraining_ppo_point_nolag_2500000", 21},
    {"pofval_poftraining_ppo_point_nolag_1000000", 41},
    {"pofval_poftraining_ppo_point_nolag_500000", 61},
    {"pofval_poftraining_ppo_point_nolag_250000", 81},
    {"pofval_poftraining_ppo_point_nolag_100000", 101},
    {"pofval_poftraining_ppo_point_nolag_50000", 121},
    {"pofval_poftraining_ppo_point_nolag_25000", 141},
    {"pofval_poftraining_ppo_point_nolag_10000", 161},
    {"pofval_poftraining_ppo_point_nolag_5000", 181},
    {"pofval_poftraining_ppo_point_lag0.5", 201},
    {"pofval_poftraining_ppo_point_lag1.5", 2210},
    {"pofval_pretraining_ppo_point_nolag", 241},
    {"pofval_pretraining_ppo_point_lag0.5", 261},
    {"pofval_pretraining_ppo_point_lag1.5", 281},
    {"pofval_nopretraining_ppo_point_init", 301} //#####
};
int main(int argc, char** argv) {
    if (argc != 3) {
        cout << "NUM_ARG ERROR" << endl;
        exit(1);
    }
    string exp_name = argv[1];
    int key_offset = -1;
    for (const auto& pair : val_exp_set) {
        if (pair.first == exp_name) {
            key_offset = pair.second;
            break;
        }
    }    
    if (key_offset == -1) {
        cout << "EXP_NAME ERROR" << endl;
        exit(1);
    }
    string checkpoint = argv[2];
    for (int thread_order = 0; thread_order < 10; thread_order++) threads[thread_order] = thread(run, exp_name, checkpoint, key_offset, thread_order);
    for (int thread_order = 0; thread_order < 10; thread_order++) threads[thread_order].join();
    return 0;
}